<?php
    $img_slider = isset($img_slider) ? $img_slider : true;
    $is_lazyload = isset($lazyload) ? $lazyload : true;
?>

<div class="property-listing property-2 <?php echo e($class_extend ?? ''); ?>"
     data-lat="<?php echo e($property->latitude); ?>"
     data-long="<?php echo e($property->longitude); ?>">
    <div class="listing-img-wrapper">
        <div class="list-img-slide">
            <div class="click <?php if(!$img_slider): ?> not-slider <?php endif; ?>">
                <?php $__currentLoopData = $property['images']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div>
                        <a href="<?php echo e($property->url); ?>">
                            <?php if($is_lazyload): ?>
                            <img src="<?php echo e(get_image_loading()); ?>"
                                data-src="<?php echo e(RvMedia::getImageUrl($image, 'medium', false, RvMedia::getDefaultImage())); ?>"
                                class="img-fluid mx-auto lazy" alt="<?php echo e($property->name); ?>"/>
                            <?php else: ?>
                            <img src="<?php echo e(RvMedia::getImageUrl($image, 'medium', false, RvMedia::getDefaultImage())); ?>"
                                class="img-fluid mx-auto" alt="<?php echo e($property->name); ?>"/>
                            <?php endif; ?>
                        </a>
                    </div>
                    <?php if(!$img_slider): ?> <?php break; ?> <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <div class="icon-actions-wrapper">
            <a href="JavaScript:Void(0);" data-id="<?php echo e($property->id); ?>" class="add-to-wishlist">
                <i class="far fa-heart"></i>
            </a>
        </div>
    </div>

    <div class="listing-detail-wrapper">
        <div class="listing-short-detail-wrap">
            <div class="listing-short-detail">
                <div class="list-price d-flex justify-content-between">
                    <span class="prt-types <?php echo e($property->type->slug); ?>"><?php echo e($property->type_name); ?></span>
                    <h6 class="listing-card-info-price">
                        <?php echo e($property->price_html); ?>

                    </h6>
                </div>
                <h4 class="listing-name">
                    <a href="<?php echo e($property->url); ?>" class="prt-link-detail"
                       title="<?php echo e($property->name); ?>"><?php echo clean($property->name); ?></a>
                </h4>
                <?php if(is_review_enabled() && $property->reviews_count > 0): ?>
                    <?php echo Theme::partial('real-estate.elements.property-review', compact('property')); ?>

                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="price-features-wrapper">
        <div class="list-fx-features">
            <div class="listing-card-info-icon">
                <div class="inc-fleat-icon">
                    <img src="<?php echo e(Theme::asset()->url('img/bed.svg')); ?>" width="13" alt=""/>
                </div>
                <?php echo clean($property->number_bedroom); ?> <?php echo __('Beds'); ?>

            </div>
            <div class="listing-card-info-icon">
                <div class="inc-fleat-icon">
                    <img src="<?php echo e(Theme::asset()->url('img/bathtub.svg')); ?>" width="13"
                         alt=""/>
                </div>
                <?php echo clean($property->number_bathroom); ?> <?php echo __('Bath'); ?>

            </div>
            <div class="listing-card-info-icon">
                <div class="inc-fleat-icon">
                    <img src="<?php echo e(Theme::asset()->url('img/move.svg')); ?>" width="13" alt=""/>
                </div>
                <?php echo e($property->square_text); ?>

            </div>
        </div>
    </div>

    <div class="listing-detail-footer">
        <div class="footer-first">
            <div class="foot-location d-flex">
                <img src="<?php echo e(Theme::asset()->url('img/pin.svg')); ?>" width="18"
                     alt="<?php echo clean($property->city_name ); ?>"/>
                <?php echo clean($property->city_name ); ?>

            </div>
        </div>
        <div class="footer-flex">
            <a href="<?php echo e($property->url); ?>" class="prt-view"><?php echo e(__('View')); ?></a>
        </div>
    </div>
</div>
<?php /**PATH /home/propertypluscom/public_html/platform/themes/resido/partials/real-estate/properties/item-grid.blade.php ENDPATH**/ ?>